//+------------------------------------------------------------------+
//|                                                  EUREKA v7.0.mq4 |
//+------------------------------------------------------------------+
#property copyright ""
#property link      ""

extern string ____1___         = " ";
extern int    Displacement     = 0;            //    
extern int    steps            = 10;           //   ,  
extern bool   Line             = false;         //   ,   
extern int    quantity         = 10;           //     

extern string ____2___         = " ";
extern double Lots             = 0.01;         //  
extern int    StopLoss         = 5;            //    
extern int    TakeProfit       = 5;            //    
extern int    MagicNumber      = 28081975;     //   
extern int    Slippage         = 3;            //  
extern int    NumberOfTry      = 5;            //    

extern bool   UseSound         = True;         //   
extern string NameFileSound    = "expert.wav"; //   
extern color  clOpenBuy        = LightBlue;    //    
extern color  clOpenSell       = LightCoral;   //    
extern color  clDelete         = Honeydew;     //    
extern color  clCloseBuy       = Aqua;         //    
extern color  clCloseSell      = Tomato;       //    
extern string NameCloseSound = "ok.wav";       //   

extern string ____________ = "______  __________________";
extern bool   Traling          = true;         //   
extern bool   TSProfitOnly     = true;         //  ,      .  True,       ,      TStop.Buy/Sell+TrailingStep .  False,       ,          ,  TStop.Buy/Sell+TrailingStep .    True       ,   False   .
extern int    TStop.Buy        = 35;           //      .
extern int    TStop.Sell       = 40;           //      .
extern int    TrailingStep     = 2;            //    .   ,      .

extern string _____Averag_____ = "______  _____";
extern bool   AVERAGES         = true;         //   
extern int    Averag           = 25;           //         
extern double koef_averag      = 1.0;          // .   Averag
extern int    alfa_lot         = 1;            // .      1- 2-
extern double koef_lot         = 2;            // .    
extern double StopLoss_Av      = 0;            //   ,  = 0
//extern bool   Avto_TP          = true;       //    ,  true  TakeProfit_Av,  False  TakProfit_Manual
extern int    TakeProfit_Av    = 10;           //         
extern bool   Close_and_TRL    = false;         // 
extern int    TRL              = 5;            // 
//extern int    TakProfit_Manual = 50;         //      
extern int    MagNum_Av        = 333;          //   

//-------    -------------------------------------+
bool          gbDisabled       = False;        //   
bool          gbNoInit         = False;        //   
int           NumberAccount    = 0;            //   
extern bool          ShowComment      = false;         //  
//-------    -----------------------------------------+
#include <stdlib.mqh>                          //   4

//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
//----
  gbNoInit=False;
  if (!IsTradeAllowed()) {
    Message("    \n"+
            "  ");
    gbNoInit=True; return;
  }
  if (!IsLibrariesAllowed()) {
    Message("    \n"+
            "    ");
    gbNoInit=True; return;
  }
  if (!IsTesting()) {
    if (IsExpertEnabled()) Message("    ");
    else Message("  \"  \"");
  }   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
//----
 if (!IsTesting()) Comment("");    
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
//----
  if (gbDisabled) {
    Message(" !  !"); return;
  }
  if (gbNoInit) {
    Message("   !"); return;
  }
  if (!IsTesting()) {
    if (NumberAccount>0 && NumberAccount!=AccountNumber()) {
      Comment("  : "+AccountNumber()+" !");
      return;
    } else Comment(""); }
    if (ShowComment) {
      string st="CurTime="+TimeToStr(TimeCurrent(), TIME_MINUTES)
               +"  .="+DoubleToStr(quantity*2,0)
               +"  .  ="+steps
               +"  TakeProfit="+TakeProfit
               +"  StopLoss="+StopLoss
               +"  Lots="+DoubleToStr(Lots,2)
               +"  ="+Displacement
               +"\n+------------------------------+"
	            +"\n   ="+DoubleToStr(AccountBalance(), 2)
               +"\n   ="+DoubleToStr(AccountEquity(), 2)
               +"\n   ="+DoubleToStr(AccountEquity()-AccountBalance(),3)+" $"
               +"\n   ="+DoubleToStr((AccountEquity()/AccountBalance()-1)*100,3)+" %"
               +"\n+------------------------------+"                              
               ;
      Comment(st);
    } else Comment("");
//***************************    *************+
 if(Traling && !ExistPositions(Symbol(),OP_BUY,MagNum_Av))SimpleTrailing(Symbol(),OP_BUY,MagicNumber);   
 if(Traling && !ExistPositions(Symbol(),OP_SELL,MagNum_Av))SimpleTrailing(Symbol(),OP_SELL,MagicNumber);
//**************************************************************+
 double STOPLEVEL = MarketInfo(Symbol(),MODE_STOPLEVEL)*Point;
//"""""""""""""""""""""" """""""""""""""""""""""""
 int vDigits =Digits;//        
 double vMn = 100;
 if (vDigits==3 || vDigits >= 5) vMn = 1000;
 int MoneyProfit = Lots*1000*TakeProfit_Av/vMn;//
 
 double PF_Buy = GetProfitOpenPosInCurrency(Symbol(),OP_BUY);
 double PF_Sel = GetProfitOpenPosInCurrency(Symbol(),OP_SELL); 
 double Lot_Av = 0, sl_a = 0, tp_a = 0;

 int count_buy2 = NumberOfPositions(Symbol(),OP_BUY,MagNum_Av);
 int count_sel2 = NumberOfPositions(Symbol(),OP_SELL,MagNum_Av);
 int count_buy = NumberOfPositions(Symbol(),OP_BUY);
 int count_sel = NumberOfPositions(Symbol(),OP_SELL);  
//----ClosePosFirstProfit(NULL, OP_BUY, MagicNumber);
 if(count_buy2>0 && PF_Buy>MoneyProfit){if(Close_and_TRL)ClosePosFirstProfit(Symbol(),OP_BUY);
 else SimpleTrailing3(Symbol(),OP_BUY);}
 if(count_sel2>0 && PF_Sel>MoneyProfit){if(Close_and_TRL)ClosePosFirstProfit(Symbol(),OP_SELL);
 else SimpleTrailing3(Symbol(),OP_SELL);}
//----
if(AVERAGES &&  NevBar()){ 
 if(PriceOpenLastPos(Symbol(),OP_BUY)-Ask>Averag*Point*count_buy*koef_averag && PF_Buy<0)
  {    
   Lot_Av =NormalizeDouble(GetLotLastPos(NULL,OP_BUY)*koef_lot,alfa_lot);         
   if (StopLoss_Av  >0) sl_a=Bid-StopLoss_Av*Point; else sl_a=0;
   OpenPosition(Symbol(), OP_BUY, Lot_Av, sl_a,0, MagNum_Av);  
  }
  
 if(Bid - PriceOpenLastPos(Symbol(),OP_SELL)>Averag*Point*count_sel*koef_averag && PF_Sel<0)
  {    
   Lot_Av =NormalizeDouble(GetLotLastPos(NULL,OP_SELL)*koef_lot,alfa_lot);         
   if (StopLoss_Av  >0) sl_a=Ask+StopLoss_Av*Point; else sl_a=0;
   OpenPosition(Symbol(), OP_SELL, Lot_Av, sl_a,0, MagNum_Av);  
  }
}  
//===============================================================
 int i = 0;
 double level_buy =Displacement*Point, level_sell = 0;
   
 while(level_buy<Bid){level_buy += steps*Point;i++;}//     
 level_sell = level_buy - steps*Point; //    
      
 if(Line){SetHLine(Lime,"r", level_buy);SetHLine(Red,"s", level_sell);}//     
//----
 double sl = 0, tp = 0;
//----  
 if(!ExistPositions(Symbol(),OP_BUY,MagicNumber)){
   for(int z =0;z<quantity;z++)
    {
    double levels_b = level_buy+z*steps*Point; 
    if(!ExistOrdersByPrice(Symbol(), OP_BUYSTOP, MagicNumber, levels_b) && 
       !ExistPosByPrice(Symbol(), OP_BUY, MagicNumber, levels_b) && 
       levels_b - Ask > STOPLEVEL)
    {
    if (StopLoss  >0)  sl=levels_b-StopLoss*Point;   else sl=0;
    if (TakeProfit >0) tp=levels_b+TakeProfit*Point; else tp=0;
    SetOrder(Symbol(), OP_BUYSTOP, Lots, levels_b, sl, tp, MagicNumber );
    }        
    }
   //----     
   for(int zd =0;zd<=10;zd++)
    {
    double levels_bd = level_buy+(zd+quantity)*steps*Point; 
    if(ExistOrdersByPrice(Symbol(), OP_BUYSTOP, MagicNumber, levels_bd))
    CloseOrderBySelect();       
    }
 }
//----
//----  
 if(!ExistPositions(Symbol(),OP_SELL,MagicNumber)){
   for(int y =0;y<quantity;y++)
    {
    double levels_s = level_sell-y*steps*Point; 
    if(!ExistOrdersByPrice(Symbol(), OP_SELLSTOP, MagicNumber, levels_s) && 
       !ExistPosByPrice(Symbol(), OP_SELL, MagicNumber, levels_s) && 
       Bid - levels_s > STOPLEVEL)
    {
    if (StopLoss  >0)  sl=levels_s+StopLoss*Point;   else sl=0;
    if (TakeProfit >0) tp=levels_s-TakeProfit*Point; else tp=0;
    SetOrder(Symbol(), OP_SELLSTOP, Lots, levels_s, sl, tp, MagicNumber);
    }        
    }
   //----     
   for(int yd =0;yd<=10;yd++)
    {
    double levels_sd = level_sell-(yd+quantity)*steps*Point; 
    if(ExistOrdersByPrice(Symbol(), OP_SELLSTOP, MagicNumber, levels_sd))
    CloseOrderBySelect();       
    }
 }
//-----------
   return(0);
  }
//+----------------------------------------------------------------------------+
//|   :   OBJ_HLINE                 |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    cl -                                                           |
//|    nm -                ("" -    )     |
//|    p1 -              (0  - Bid)                              |
//|    st -                  (0  -  )                    |
//|    wd -                 (0  -  )                     |
//+----------------------------------------------------------------------------+
void SetHLine(color cl, string nm="", double p1=0, int st=0, int wd=1) {
  if (nm=="") nm=DoubleToStr(Time[0], 0);
  if (p1<=0) p1=Bid;
  if (ObjectFind(nm)<0) ObjectCreate(nm, OBJ_HLINE, 0, 0,0);
  ObjectSet(nm, OBJPROP_PRICE1, p1);
  ObjectSet(nm, OBJPROP_COLOR , cl);
  ObjectSet(nm, OBJPROP_STYLE , st);
  ObjectSet(nm, OBJPROP_WIDTH , wd);
}
//+----------------------------------------------------------------------------+
//|   :               |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    sy -     (""   -  ,                   |
//|                                     NULL -  )                 |
//|    op -                    (-1   -  )                  |
//|    mn - MagicNumber                (-1   -  )                    |
//|    pp -                        (-1   -  )                     |
//+----------------------------------------------------------------------------+
bool ExistOrdersByPrice(string sy="", int op=-1, int mn=-1, double pp=-1) {
  int d, i, k=OrdersTotal();

  if (sy=="0") sy=Symbol();
  for (i=0; i<k; i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if ((OrderSymbol()==sy || sy=="") && (op<0 || OrderType()==op)) {
        if (OrderType()>1 && OrderType()<6) {
          d=MarketInfo(OrderSymbol(), MODE_DIGITS);
          pp=NormalizeDouble(pp, d);
          if (pp<0 || pp==NormalizeDouble(OrderOpenPrice(), d)) {
            if (mn<0 || OrderMagicNumber()==mn) return(True);
          }
        }
      }
    }
  }
  return(False);
}
//+----------------------------------------------------------------------------+
//|   :                |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    sy -     (""   -  ,                   |
//|                                     NULL -  )                 |
//|    op -            (-1   -  )                  |
//|    mn - MagicNumber                (-1   -  )                    |
//|    pp -                        ( 0   -  )                     |
//+----------------------------------------------------------------------------+
bool ExistPosByPrice(string sy="", int op=-1, int mn=-1, double pp=0) {
  double px, py;
  int    d, i, k=OrdersTotal();

  if (sy=="0") sy=Symbol();
  for (i=0; i<k; i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if ((OrderSymbol()==sy || sy=="") && (op<0 || OrderType()==op)) {
        if (OrderType()==OP_BUY || OrderType()==OP_SELL) {
          if (mn<0 || OrderMagicNumber()==mn) {
            d=MarketInfo(OrderSymbol(), MODE_DIGITS);
            px=NormalizeDouble(pp, d);
            py=NormalizeDouble(OrderOpenPrice(), d);
            if (pp<=0 || px==py) return(True);
          }
        }
      }
    }
  }
  return(False);
}
//+----------------------------------------------------------------------------+                                                    |
//|   :  .                                              |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    sy -     (NULL  "" -  )          |
//|    op -                                                            |
//|    ll -                                                                 |
//|    pp -                                                                |
//|    sl -                                                         |
//|    tp -                                                         |
//|    mn - Magic Number                                                       |
//|    ex -                                                       |
//+----------------------------------------------------------------------------+
void SetOrder(string sy, int op, double ll, double pp,
              double sl=0, double tp=0, int mn=0, datetime ex=0) {
  color    clOpen;
  datetime ot;
  double   pa, pb, mp;
  int      err, it, ticket, msl;
  string   lsComm=WindowExpertName()+" "+GetNameTF(Period());

  if (sy=="" || sy=="0") sy=Symbol();
  msl=MarketInfo(sy, MODE_STOPLEVEL);
  if (op==OP_BUYLIMIT || op==OP_BUYSTOP) clOpen=clOpenBuy; else clOpen=clOpenSell;
  if (ex>0 && ex<TimeCurrent()) ex=0;
  for (it=1; it<=NumberOfTry; it++) {
    if (!IsTesting() && (!IsExpertEnabled() || IsStopped())) {
      Print("SetOrder():   ");
      break;
    }
    while (!IsTradeAllowed()) Sleep(5000);
    RefreshRates();
    ot=TimeCurrent();
    ticket=OrderSend(sy, op, ll, pp, Slippage, sl, tp, lsComm, mn, ex, clOpen);
    if (ticket>0) {
      if (UseSound) PlaySound(NameFileSound); break;
    } else {
      err=GetLastError();
      if (err==128 || err==142 || err==143) {
        Sleep(1000*66);
        if (ExistOrders(sy, op, mn, ot)) {
          if (UseSound) PlaySound(NameFileSound); break;
        }
        Print("Error(",err,") set order: ",ErrorDescription(err),", try ",it);
        continue;
      }
      mp=MarketInfo(sy, MODE_POINT);
      pa=MarketInfo(sy, MODE_ASK);
      pb=MarketInfo(sy, MODE_BID);
      //  
      if (err==130) {
        switch (op) {
          case OP_BUYLIMIT:
            if (pp>pa-msl*mp) pp=pa-msl*mp;
            if (sl>pp-(msl+1)*mp) sl=pp-(msl+1)*mp;
            if (tp>0 && tp<pp+(msl+1)*mp) tp=pp+(msl+1)*mp;
            break;
          case OP_BUYSTOP:
            if (pp<pa+(msl+1)*mp) pp=pa+(msl+1)*mp;
            if (sl>pp-(msl+1)*mp) sl=pp-(msl+1)*mp;
            if (tp>0 && tp<pp+(msl+1)*mp) tp=pp+(msl+1)*mp;
            break;
          case OP_SELLLIMIT:
            if (pp<pb+msl*mp) pp=pb+msl*mp;
            if (sl>0 && sl<pp+(msl+1)*mp) sl=pp+(msl+1)*mp;
            if (tp>pp-(msl+1)*mp) tp=pp-(msl+1)*mp;
            break;
          case OP_SELLSTOP:
            if (pp>pb-msl*mp) pp=pb-msl*mp;
            if (sl>0 && sl<pp+(msl+1)*mp) sl=pp+(msl+1)*mp;
            if (tp>pp-(msl+1)*mp) tp=pp-(msl+1)*mp;
            break;
        }
        Print("SetOrder():   ");
      }
      Print("Error(",err,") set order: ",ErrorDescription(err),", try ",it);
      Print("Ask=",pa,"  Bid=",pb,"  sy=",sy,"  ll=",ll,"  op=",GetNameOP(op),
            "  pp=",pp,"  sl=",sl,"  tp=",tp,"  mn=",mn);
      if (pa==0 && pb==0) Message("SetOrder():       "+sy);
      //   
      if (err==2 || err==64 || err==65 || err==133) {
        gbDisabled=True; break;
      }
      //  
      if (err==4 || err==131 || err==132) {
        Sleep(1000*300); break;
      }
      //    (8)     (141)
      if (err==8 || err==141) Sleep(1000*100);
      if (err==139 || err==140 || err==148) break;
      //    
      if (err==146) while (IsTradeContextBusy()) Sleep(1000*11);
      //   
      if (err==147) {
        ex=0; continue;
      }
      if (err!=135 && err!=138) Sleep(1000*7.7);
    }
  }
}
//+----------------------------------------------------------------------------+
//|   :                                |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    TimeFrame -  ( )      (0 -  )         |
//+----------------------------------------------------------------------------+
string GetNameTF(int TimeFrame=0) {
  if (TimeFrame==0) TimeFrame=Period();
  switch (TimeFrame) {
    case PERIOD_M1:  return("M1");
    case PERIOD_M5:  return("M5");
    case PERIOD_M15: return("M15");
    case PERIOD_M30: return("M30");
    case PERIOD_H1:  return("H1");
    case PERIOD_H4:  return("H4");
    case PERIOD_D1:  return("Daily");
    case PERIOD_W1:  return("Weekly");
    case PERIOD_MN1: return("Monthly");
    default:         return("UnknownPeriod");
  }
}
//+----------------------------------------------------------------------------+                                                    |
//|   :    .                         |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    sy -     (""   -  ,                   |
//|                                     NULL -  )                 |
//|    op -                    (-1   -  )                    |
//|    mn - MagicNumber                (-1   -  )                    |
//|    ot -               ( 0   -   )          |
//+----------------------------------------------------------------------------+
bool ExistOrders(string sy="", int op=-1, int mn=-1, datetime ot=0) {
  int i, k=OrdersTotal(), ty;
 
  if (sy=="0") sy=Symbol();
  for (i=0; i<k; i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      ty=OrderType();
      if (ty>1 && ty<6) {
        if ((OrderSymbol()==sy || sy=="") && (op<0 || ty==op)) {
          if (mn<0 || OrderMagicNumber()==mn) {
            if (ot<=OrderOpenTime()) return(True);
          }
        }
      }
    }
  }
  return(False);
}
//+----------------------------------------------------------------------------+
//|   :                          |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    op -                                       |
//+----------------------------------------------------------------------------+
string GetNameOP(int op) {
  switch (op) {
    case OP_BUY      : return("Buy");
    case OP_SELL     : return("Sell");
    case OP_BUYLIMIT : return("Buy Limit");
    case OP_SELLLIMIT: return("Sell Limit");
    case OP_BUYSTOP  : return("Buy Stop");
    case OP_SELLSTOP : return("Sell Stop");
    default          : return("Unknown Operation");
  }
}
//+----------------------------------------------------------------------------+
//|   :                                  |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    m -                                                       |
//+----------------------------------------------------------------------------+
void Message(string m) {
  Comment(m);
  if (StringLen(m)>0) Print(m);
}
//+----------------------------------------------------------------------------+
//|  :                     |
//+----------------------------------------------------------------------------+
void CloseOrderBySelect() 
  {
    if (OrderSelect(OrderTicket(), SELECT_BY_TICKET, MODE_TRADES)) 
     {
      for (int it=1; it<=NumberOfTry; it++) 
       {
        if (!IsTesting() && (!IsExpertEnabled() || IsStopped())) break;
        while (!IsTradeAllowed()) Sleep(5000);
        bool fd=OrderDelete(OrderTicket(), clDelete);
        if (fd) 
         {
          if (UseSound) PlaySound(NameFileSound); break;
         } 
        else 
         {
          int err=GetLastError();
          Print(" (",err,")   BUYSTOP",": ",ErrorDescription(err),",  ",it);
          Sleep(1000*5);
         }
       }
     }
  }
//+----------------------------------------------------------------------------+
//|     : 11.09.2008                                                     |
//|   :                               |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    sy -     ( ""  -  ,                   |
//|                                     NULL -  )                 |
//|    op -                    ( -1  -  )                  |
//|    mn - MagicNumber                ( -1  -  )                    |
//+----------------------------------------------------------------------------+
void SimpleTrailing(string sy="", int op=-1, int mn=-1) {
  double po, pp;
  int    i, k=OrdersTotal();

  if (sy=="0") sy=Symbol();
  for (i=0; i<k; i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if ((OrderSymbol()==sy || sy=="") && (op<0 || OrderType()==op)) {
        po=MarketInfo(OrderSymbol(), MODE_POINT);
        if (mn<0 || OrderMagicNumber()==mn) {
          if (OrderType()==OP_BUY) {
            pp=MarketInfo(OrderSymbol(), MODE_BID);
            if (!TSProfitOnly || pp-OrderOpenPrice()>TStop.Buy*po) {
              if (OrderStopLoss()<pp-(TStop.Buy+TrailingStep-1)*po) {
                ModifyOrder(-1, pp-TStop.Buy*po, -1);
              }
            }
          }
          if (OrderType()==OP_SELL) {
            pp=MarketInfo(OrderSymbol(), MODE_ASK);
            if (!TSProfitOnly || OrderOpenPrice()-pp>TStop.Sell*po) {
              if (OrderStopLoss()>pp+(TStop.Sell+TrailingStep-1)*po || OrderStopLoss()==0) {
                ModifyOrder(-1, pp+TStop.Sell*po, -1);
              }
            }
          }
        }
      }
    }
  }
}
//+----------------------------------------------------------------------------+
//|   :     .           |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    pp -                                                 |
//|    sl -                                                 |
//|    tp -                                                 |
//|    ex -                                                       |
//+----------------------------------------------------------------------------+
void ModifyOrder(double pp=-1, double sl=0, double tp=0, datetime ex=0) {
  bool   fm;
  color  cl;
  double op, pa, pb, os, ot;
  int    dg=MarketInfo(OrderSymbol(), MODE_DIGITS), er, it;

  if (pp<=0) pp=OrderOpenPrice();
  if (sl<0 ) sl=OrderStopLoss();
  if (tp<0 ) tp=OrderTakeProfit();
  
  pp=NormalizeDouble(pp, dg);
  sl=NormalizeDouble(sl, dg);
  tp=NormalizeDouble(tp, dg);
  op=NormalizeDouble(OrderOpenPrice() , dg);
  os=NormalizeDouble(OrderStopLoss()  , dg);
  ot=NormalizeDouble(OrderTakeProfit(), dg);

  if (pp!=op || sl!=os || tp!=ot) {
    for (it=1; it<=NumberOfTry; it++) {
      if (!IsTesting() && (!IsExpertEnabled() || IsStopped())) break;
      while (!IsTradeAllowed()) Sleep(5000);
      RefreshRates();
      fm=OrderModify(OrderTicket(), pp, sl, tp, ex, cl);
      if (fm) {
        if (UseSound) PlaySound(NameFileSound); break;
      } else {
        er=GetLastError();
        pa=MarketInfo(OrderSymbol(), MODE_ASK);
        pb=MarketInfo(OrderSymbol(), MODE_BID);
        Print("Error(",er,") modifying order: ",ErrorDescription(er),", try ",it);
        Print("Ask=",pa,"  Bid=",pb,"  sy=",OrderSymbol(),
              "  op="+GetNameOP(OrderType()),"  pp=",pp,"  sl=",sl,"  tp=",tp);
        Sleep(1000*10);
      }
    }
  }
}
//+----------------------------------------------------------------------------+
//|   :         |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    sy -     (""   -  ,                   |
//|                                     NULL -  )                 |
//|    op -                    (-1   -  )                  |
//|    mn - MagicNumber                (-1   -  )                    |
//+----------------------------------------------------------------------------+
double GetProfitOpenPosInCurrency(string sy="", int op=-1, int mn=-1) {
  double p=0;
  int    i, k=OrdersTotal();

  if (sy=="0") sy=Symbol();
  for (i=0; i<k; i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if ((OrderSymbol()==sy || sy=="") && (op<0 || OrderType()==op)) {
        if (OrderType()==OP_BUY || OrderType()==OP_SELL) {
          if (mn<0 || OrderMagicNumber()==mn) {
            p+=OrderProfit()+OrderCommission()+OrderSwap();
          }
        }
      }
    }
  }
  return(p);
}
//+----------------------------------------------------------------------------+
//|   :      .           |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    sy -     (""   -  ,                   |
//|                                     NULL -  )                 |
//|    op -                    (-1   -  )                  |
//|    mn - MagicNumber                (-1   -  )                    |
//+----------------------------------------------------------------------------+
double PriceOpenLastPos(string sy="", int op=-1, int mn=-1) {
  datetime t;
  double   r=0;
  int      i, k=OrdersTotal();

  if (sy=="0") sy=Symbol();
  for (i=0; i<k; i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderSymbol()==sy || sy=="") {
        if (OrderType()==OP_BUY || OrderType()==OP_SELL) {
          if (op<0 || OrderType()==op) {
            if (mn<0 || OrderMagicNumber()==mn) {
              if (t<OrderOpenTime()) {
                t=OrderOpenTime();
                r=OrderOpenPrice();
              }
            }
          }
        }
      }
    }
  }
  return(r);
}
//+----------------------------------------------------------------------------+
//|   :        -1       |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    sy -     (""   -  ,                   |
//|                                     NULL -  )                 |
//|    op -                    (-1   -  )                  |
//|    mn - MagicNumber                (-1   -  )                    |
//+----------------------------------------------------------------------------+
double GetLotLastPos(string sy="", int op=-1, int mn=-1) {
  datetime o;
  double   l=-1;
  int      i, k=OrdersTotal();

  if (sy=="0") sy=Symbol();
  for (i=0; i<k; i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderSymbol()==sy || sy=="") {
        if (OrderType()==OP_BUY || OrderType()==OP_SELL) {
          if (op<0 || OrderType()==op) {
            if (mn<0 || OrderMagicNumber()==mn) {
              if (o<OrderOpenTime()) {
                o=OrderOpenTime();
                l=OrderLots();
              }
            }
          }
        }
      }
    }
  }
  return(l);
}
//+----------------------------------------------------------------------------+
//|   :     .                            |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    sy -     (NULL  "" -  )          |
//|    op -                                                            |
//|    ll -                                                                 |
//|    sl -                                                         |
//|    tp -                                                         |
//|    mn - MagicNumber                                                        |
//+----------------------------------------------------------------------------+
void OpenPosition(string sy, int op, double ll, double sl=0, double tp=0, int mn=0) {
  color    clOpen;
  datetime ot;
  double   pp, pa, pb;
  int      dg, err, it, ticket=0;
  string   lsComm=WindowExpertName()+" "+GetNameTF(Period());

  if (sy=="" || sy=="0") sy=Symbol();
  if (op==OP_BUY) clOpen=clOpenBuy; else clOpen=clOpenSell;
  for (it=1; it<=NumberOfTry; it++) {
    if (!IsTesting() && IsStopped()) {
      Print("OpenPosition():   ");
      break;
    }
    while (!IsTradeAllowed()) Sleep(5000);
    RefreshRates();
    dg=MarketInfo(sy, MODE_DIGITS);
    pa=MarketInfo(sy, MODE_ASK);
    pb=MarketInfo(sy, MODE_BID);
    if (op==OP_BUY) pp=pa; else pp=pb;
    pp=NormalizeDouble(pp, dg);
    ot=TimeCurrent();
      ticket=OrderSend(sy, op, ll, pp, Slippage, sl, tp, lsComm, mn, 0, clOpen);
    if (ticket>0) {
      if (UseSound) PlaySound(NameFileSound); break;
    } else {
      err=GetLastError();
      if (pa==0 && pb==0) Message("      "+sy);
      //    
      Print("Error(",err,") opening position: ",ErrorDescription(err),", try ",it);
      Print("Ask=",pa," Bid=",pb," sy=",sy," ll=",ll," op=",GetNameOP(op),
            " pp=",pp," sl=",sl," tp=",tp," mn=",mn);
      //   
      if (err==2 || err==64 || err==65 || err==133) {
        gbDisabled=True; break;
      }
      //  
      if (err==4 || err==131 || err==132) {
        Sleep(1000*300); break;
      }
      if (err==128 || err==142 || err==143) {
        Sleep(1000*66.666);
        if (ExistPositions(sy, op, mn, ot)) {
          if (UseSound) PlaySound(NameFileSound); break;
        }
      }
      if (err==140 || err==148 || err==4110 || err==4111) break;
      if (err==141) Sleep(1000*100);
      if (err==145) Sleep(1000*17);
      if (err==146) while (IsTradeContextBusy()) Sleep(1000*11);
      if (err!=135) Sleep(1000*7.7);
    }
  }
}
//+----------------------------------------------------------------------------+
//|   :                              |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    sy -     (""   -  ,                   |
//|                                     NULL -  )                 |
//|    op -                    (-1   -  )                  |
//|    mn - MagicNumber                (-1   -  )                    |
//|    ot -               ( 0   -   )           |
//+----------------------------------------------------------------------------+
bool ExistPositions(string sy="", int op=-1, int mn=-1, datetime ot=0) {
  int i, k=OrdersTotal();

  if (sy=="0") sy=Symbol();
  for (i=0; i<k; i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderSymbol()==sy || sy=="") {
        if (OrderType()==OP_BUY || OrderType()==OP_SELL) {
          if (op<0 || OrderType()==op) {
            if (mn<0 || OrderMagicNumber()==mn) {
              if (ot<=OrderOpenTime()) return(True);
            }
          }
        }
      }
    }
  }
  return(False);
}
//================================================================
/*  
void SimpleTrailing2(string sy="", int op=-1, int mn=-1, double cn = 0) {
  double po, pp;
  int    i, k=OrdersTotal();

  if (sy=="0") sy=Symbol();
  for (i=0; i<k; i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if ((OrderSymbol()==sy || sy=="") && (op<0 || OrderType()==op)) {
        if (mn<0 || OrderMagicNumber()==mn) {
                
          if (OrderType()==OP_BUY) {
            if (NormalizeDouble(OrderTakeProfit(),Digits)!=NormalizeDouble(cn,Digits) || OrderTakeProfit()==0) {
                ModifyOrder(-1,-1,cn);
            }
          }
          if (OrderType()==OP_SELL) {
            if (NormalizeDouble(OrderTakeProfit(),Digits)!=NormalizeDouble(cn,Digits)) {
                ModifyOrder(-1,-1,cn);
            }
          }
        }
      }
    }
  }
}*/
//----------------------------------------------------------------------
bool NevBar() {
   static int PrevBar=0;
   if (PrevBar==Time[0]) return(false);
   PrevBar=Time[0];
   return(true);
}
//+----------------------------------------------------------------------------+
//|   :   .                                 |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    sy -     (""   -  ,                   |
//|                                     NULL -  )                 |
//|    op -                    (-1   -  )                  |
//|    mn - MagicNumber                (-1   -  )                    |
//+----------------------------------------------------------------------------+
int NumberOfPositions(string sy="", int op=-1, int mn=-1) {
  int i, k=OrdersTotal(), kp=0;

  if (sy=="0") sy=Symbol();
  for (i=0; i<k; i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderSymbol()==sy || sy=="") {
        if (OrderType()==OP_BUY || OrderType()==OP_SELL) {
          if (op<0 || OrderType()==op) {
            if (mn<0 || OrderMagicNumber()==mn) kp++;
          }
        }
      }
    }
  }
  return(kp);
}
/*
//+----------------------------------------------------------------------------+
//|  :                                                  |
//+----------------------------------------------------------------------------+
//| :                                                                 |
//|   sy -     ( ""  -  ,                    |
//|                                    NULL -  )                  |
//|   op -                    (  -1 -  )                     |
//|   mn - MagicNumber                (  -1 -  )                     |
//+----------------------------------------------------------------------------+
void DeleteOrders(string sy="", int op=-1, int mn=-1) {
  bool fd;
  int err, i, it, k=OrdersTotal(), ot;
  
  if (sy=="0") sy=Symbol();
  for (i=k-1; i>=0; i--) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      ot=OrderType();
      if (ot>1 && ot<6) {
        if ((OrderSymbol()==sy || sy=="") && (op<0 || ot==op)) {
          if (mn<0 || OrderMagicNumber()==mn) {
            for (it=1; it<=NumberOfTry; it++) {
              if (!IsTesting() && (!IsExpertEnabled() || IsStopped())) break;
              while (!IsTradeAllowed()) Sleep(5000);
              fd=OrderDelete(OrderTicket(), clDelete);
              if (fd) {
                if (UseSound) PlaySound(NameFileSound); break;
              } else {
                err=GetLastError();
                Print("Error(",err,") delete order ",GetNameOP(ot),
                      ": ",ErrorDescription(err),", try ",it);
                Sleep(1000*5);
              }
            }
          }
        }
      }
    }
  }
}
*/
//+----------------------------------------------------------------------------+
//|   :                  |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    sy -     (""   -  ,                   |
//|                                     NULL -  )                 |
//|    op -                    (-1   -  )                  |
//|    mn - MagicNumber                (-1   -  )                    |
//+----------------------------------------------------------------------------+
void ClosePosFirstProfit(string sy="", int op=-1, int mn=-1) {
  int i, k=OrdersTotal();
  if (sy=="0") sy=Symbol();

  //    
  for (i=k-1; i>=0; i--) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if ((OrderSymbol()==sy || sy=="") && (op<0 || OrderType()==op)) {
        if (OrderType()==OP_BUY || OrderType()==OP_SELL) {
          if (mn<0 || OrderMagicNumber()==mn) {
            if (OrderProfit()+OrderSwap()>0) ClosePosBySelect();
          }
        }
      }
    }
  }
  //   
  k=OrdersTotal();
  for (i=k-1; i>=0; i--) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if ((OrderSymbol()==sy || sy=="") && (op<0 || OrderType()==op)) {
        if (OrderType()==OP_BUY || OrderType()==OP_SELL) {
          if (mn<0 || OrderMagicNumber()==mn) ClosePosBySelect();
        }
      }
    }
  }
}
//+----------------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru                   |
//+----------------------------------------------------------------------------+
//|    : 19.02.2008                                                      |
//|  :                      |
//+----------------------------------------------------------------------------+
void ClosePosBySelect() {
  bool   fc;
  color  clClose;
  double ll, pa, pb, pp;
  int    err, it;

  if (OrderType()==OP_BUY || OrderType()==OP_SELL) {
    for (it=1; it<=NumberOfTry; it++) {
      if (!IsTesting() && (!IsExpertEnabled() || IsStopped())) break;
      while (!IsTradeAllowed()) Sleep(5000);
      RefreshRates();
      pa=MarketInfo(OrderSymbol(), MODE_ASK);
      pb=MarketInfo(OrderSymbol(), MODE_BID);
      if (OrderType()==OP_BUY) {
        pp=pb; clClose=clCloseBuy;
      } else {
        pp=pa; clClose=clCloseSell;
      }
      ll=OrderLots();
      fc=OrderClose(OrderTicket(), ll, pp, Slippage, clClose);
      if (fc) {
        if (UseSound) PlaySound(NameCloseSound); break;
      } else {
        err=GetLastError();
        if (err==146) while (IsTradeContextBusy()) Sleep(1000*11);
        Print("Error(",err,") Close ",GetNameOP(OrderType())," ",
              ErrorDescription(err),", try ",it);
        Print(OrderTicket(),"  Ask=",pa,"  Bid=",pb,"  pp=",pp);
        Print("sy=",OrderSymbol(),"  ll=",ll,"  sl=",OrderStopLoss(),
              "  tp=",OrderTakeProfit(),"  mn=",OrderMagicNumber());
        Sleep(1000*5);
      }
    }
  } else Print("  . Close ",GetNameOP(OrderType()));
}
//+----------------------------------------------------------------------------+
//|     : 11.09.2008                                                     |
//|   :                               |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    sy -     ( ""  -  ,                   |
//|                                     NULL -  )                 |
//|    op -                    ( -1  -  )                  |
//|    mn - MagicNumber                ( -1  -  )                    |
//+----------------------------------------------------------------------------+
void SimpleTrailing3(string sy="", int op=-1, int mn=-1) {
  double po, pp;
  int    i, k=OrdersTotal();

  if (sy=="0") sy=Symbol();
  for (i=0; i<k; i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if ((OrderSymbol()==sy || sy=="") && (op<0 || OrderType()==op)) {
        po=MarketInfo(OrderSymbol(), MODE_POINT);
        if (mn<0 || OrderMagicNumber()==mn && TRL<TakeProfit_Av) {
          if (OrderType()==OP_BUY) {
            pp=MarketInfo(OrderSymbol(), MODE_BID);
            if (OrderStopLoss()<pp-TakeProfit_Av*po)
            ModifyOrder(-1, pp-TRL*po, -1);
          }
          if (OrderType()==OP_SELL) {
            pp=MarketInfo(OrderSymbol(), MODE_ASK);
            if (OrderStopLoss()>pp+TakeProfit_Av*po || OrderStopLoss()==0)
            ModifyOrder(-1, pp+TRL*po, -1);
          }
        }
      }
    }
  }
}